    <?php
	/*
	* copyright (c) 2013-2023 Heliac Technologies
	* license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
	*
	* linee guida per l'utilizzo del logo https://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
	*/
    
        $data1MeseFa       = date("Y-m-d h:i:sa", strtotime("-1 Months"));
        $queryUtentiAttivi = "SELECT * FROM geec_utenti WHERE ultimoLogin > '$data1MeseFa'";
        $risUtentiAttivi   = $geecomDb->eseguiQueryLettura($queryUtentiAttivi);
        $utentiAttivi      = $risUtentiAttivi->num_rows;
        $numeroUtenti      = $geecomDb->contaRigheTabella("geec_utenti");
        $datiStatistiche   = $geecomDb->leggiSingolaRiga("geecB_statistiche",1);
        
        $dataOggi          = new DateTime();
        $dataInstallazione = new DateTime($datiStatistiche["dataInstallazione"]);
        $differenzaGiorni  = ($dataOggi->diff($dataInstallazione))->days;

        if($analisiSito["giorniDallultimaPubblicazione"]>30) {
    ?>
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                <p><strong><i class="fa fa-frown-o" aria-hidden="true"></i> ATTENZIONE...</strong><hr>Non scrivi nulla da <strong><?php echo $analisiSito["giorniDallultimaPubblicazione"]; ?> giorni</strong>, coinvolgi i tuoi utenti creando contenuti sempre aggiornati <a class="btn btn-success" href="../controller/controllerContenuti.php?operazione=creaArticolo" >Crea un articolo</a></p>
                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
    <?php
        }
        else if($analisiSito["giorniDallultimaPubblicazione"]>14) {
    ?>
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                <p><strong><i class="fa fa-meh-o" aria-hidden="true"></i> ATTENZIONE...</strong><hr>Non scrivi nulla da <strong><?php echo $analisiSito["giorniDallultimaPubblicazione"]; ?> giorni</strong>, coinvolgi i tuoi utenti creando contenuti sempre aggiornati <a class="btn btn-success" href="../controller/controllerContenuti.php?operazione=creaArticolo" >Crea un articolo</a></p>
                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
    <?php
        }
    ?>

    <div class="row mb-3">
        <div class="col">
            <div class="collapse <?= (isset($_GET["gestisciComponenti"])) ? "show in" : "" ?>" id="elementiDashboard">
                <div class="card card-body border-0">
                    <form class="form-inline">
                        <div class="custom-control custom-checkbox custom-control-inline">
                            <input type="checkbox" id="customCheckboxInline1" name="customCheckboxInline1" class="custom-control-input" checked disabled>
                            <label class="custom-control-label" for="customCheckboxInline1">Statistiche</label>
                        </div>
                        
                        <div class="custom-control custom-checkbox custom-control-inline">
                            <input type="checkbox" id="customCheckboxInline2" name="customCheckboxInline2" class="custom-control-input" checked disabled>
                            <label class="custom-control-label" for="customCheckboxInline2">Sintesi contenuti</label>
                        </div>
                        
                        <?php 
                            $queryCruscottiComponentiSpecifici = "SELECT * FROM geecB_componenti WHERE nome LIKE 'Annunci' OR nome LIKE 'Ecommerce' or nome LIKE 'Hotel manager' ORDER BY id DESC";
                            $risCruscottiSpecifici             = $geecomDb->eseguiQueryLettura($queryCruscottiComponentiSpecifici);
                            while($componenteConCruscotto = $risCruscottiSpecifici->fetch_assoc()) {
                                ?>
                                <div class="custom-control custom-checkbox custom-control-inline">
                                    <input type="checkbox" id="checboxMostraTabellaRiassuntiva<?= $componenteConCruscotto["id"] ?>"  class="custom-control-input" <?= ($componenteConCruscotto["tabellaRiassuntivaHome"]=="si") ? "checked" : "" ?> onchange="attivaDisattivaTabellaRiassuntivaHome(<?= $componenteConCruscotto["id"] ?>)">
                                    <label class="custom-control-label" for="checboxMostraTabellaRiassuntiva<?= $componenteConCruscotto["id"] ?>"><?= $componenteConCruscotto["nome"] ?></label>
                                </div>
                                <?php 
                            }
                            
                            // recupero i componenti di tipo tabellaRiassuntivaHome progettati appositametne per questo scopo
                            $queryCruscottiComponenti = "SELECT * FROM geecB_componenti WHERE tipo LIKE 'tabellaRiassuntivaHome' ORDER BY id DESC";
                            $risCruscotti             = $geecomDb->eseguiQueryLettura($queryCruscottiComponenti);
                            while($componenteConCruscotto = $risCruscotti->fetch_assoc()) {
                                ?>
                                <div class="custom-control custom-checkbox custom-control-inline">
                                    <input type="checkbox" id="checboxMostraTabellaRiassuntiva<?= $componenteConCruscotto["id"] ?>"  class="custom-control-input" <?= ($componenteConCruscotto["tabellaRiassuntivaHome"]=="si") ? "checked" : "" ?> onchange="attivaDisattivaTabellaRiassuntivaHome(<?= $componenteConCruscotto["id"] ?>)">
                                    <label class="custom-control-label" for="checboxMostraTabellaRiassuntiva<?= $componenteConCruscotto["id"] ?>"><?= $componenteConCruscotto["nome"] ?></label>
                                </div>
                                <?php 
                            }
                            
                            $classiElementiStatistici = [
                            	"col-12"=>"1",
                            	"col-xl-6"=>"2",
                            	"col-xl-4"=>"3",
                            	"col-xl-3"=>"4"
                            ];
                        ?>
                        
                        <div class="form-inline"> <label class="mr-2">Colonne statistiche per riga</label>
			    <select id="classeElementiStatistici" class="form-control" onchange="modificaClasseElementiStatisticiPerRigaHomeAdmin()">
		                <?php 
		                    foreach($classiElementiStatistici as $classe=>$numeroElementi) {
		                        $stringaSelezionata = ($impostazioni["classeElementiStatisticiPerRigaHomeAdmin"]==$classe) ? "selected" : "";
		                        echo"<option value=\"$classe\" $stringaSelezionata>$numeroElementi</option>";
		                    }
		                ?>
			    </select>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <div class="row d-flex align-items-center">
        <div class="col-md-3 mb-3 mb-md-0">
            <div class="alert alert border-<?php echo $analisiSito["classeBoxUtilizzo"]; ?> col-12 text-center mb-0 seo text-<?php echo $analisiSito["classeBoxUtilizzo"]; ?>">
                <h6><i class="<?php echo $analisiSito["icona"]; ?>"></i> Il tuo punteggio SEO è <strong><?php echo ceil($analisiSito["punteggioSito"]); ?>/100</strong></h6>
                <hr class="my-2">
                <p><?php confrontoMediaPunteggio(ceil($analisiSito["punteggioSito"])); ?><i class="fas fa-question-circle" data-toggle="tooltip" data-placement="bottom" title="Il punteggio medio dei siti Geecom è di 47 punti"></i></p>
                <a class="btn btn-<?php echo $analisiSito["classeBoxUtilizzo"]; ?> btn-sm leggi-tutto" href="statistiche.php">Dettagli</a>
            </div>
        </div>
        <div class="col-md-9">
            <div id="contatori" class="row">
                <div class="col-md-6">
                    <div class="card border-0 p-3 mb-3 mb-md-0 box-shadow-lite shadow">
                        <?php 
                            $queryTotaleVisite = "SELECT SUM(numeroVisite) FROM geecB_contenuti";
                            $risTotaleVisite = $geecomDb->eseguiQueryLettura($queryTotaleVisite);
                            $totaleVisite = $risTotaleVisite->fetch_array(MYSQLI_NUM);
                            $totaleVisiteSito = $totaleVisite[0];
                        ?>
                        <h5 class="text-primary mb-0 mx-auto"><i class="far fa-flag mr-2"></i>Visite</h5>
                        <hr>
                        <div class="row">
                            <div class="col text-center">
                                <strong>Totali</strong><br>
                                <span><?php echo $totaleVisiteSito; ?></span>
                            </div>
                            <div class="col text-center">
                                <strong>Oggi</strong><br>
                                <span><?php echo $datiStatistiche["visiteGiornaliere"]; ?></span>
                            </div>
                            <div class="col text-center">
                                <?php 
                                
                                ?>
                                <strong>Media giornaliera</strong><br>
                                <span><?php echo(($differenzaGiorni==0) ? $datiStatistiche["visiteGiornaliere"] : number_format($totaleVisiteSito/$differenzaGiorni,2)) ?></span>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="card border-0 p-3 mb-3 mb-md-0 box-shadow-lite shadow">
                        <h5 class="text-primary mb-0 mx-auto"><i class="fas fa-exchange-alt mr-2"></i>Interazioni</h5>
                        <hr>
                        <div class="row">
                            <div class="col text-center">
                                <strong>Totali</strong><br>
                                <span><?php echo($geecomDb->contaRigheTabella("geecB_commenti")); ?></span>
                            </div>
                            <div class="col text-center">
                                <?php 
                                    $date = date("Y-m-d");
                                    $queryStatistiche = "SELECT count(*) FROM geecB_commenti WHERE dataCreazione LIKE '$date'";
                                    $risStat = $geecomDb->eseguiQueryLettura($queryStatistiche);
                                    $numeroOggetti = $risStat->fetch_array(MYSQLI_NUM);
                                ?>
                                <strong>Oggi</strong><br>
                                <span><?php echo $numeroOggetti[0]; ?>
                            </div>
                            <div class="col text-center">
                                <strong>Media giornaliera</strong><br>
                                <span><?php echo(($differenzaGiorni==0) ? $numeroOggetti[0] : number_format($numeroOggetti[0]/$differenzaGiorni,2)) ?></span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <?php
        $queryCruscottiComponenti = "SELECT * FROM geecB_componenti WHERE cruscottoHome LIKE 'si'";
        $risCruscotti             = $geecomDb->eseguiQueryLettura($queryCruscottiComponenti);
        While($componenteConCruscotto = $risCruscotti->fetch_assoc()) {
            include "componenti/{$componenteConCruscotto["paginaGestione"]}/cruscottoHome.php";
        }
    ?>

    <div class="row pulsantiera my-3">
        <div class="col-sm-6 col-lg-3 mb-3 mb-lg-0">
            <div class="text-light item">
                <div class="p-3">
                    <h3 class="mb-1"><span class=""><?php echo $geecomDb->contaRigheTabella("geecB_contenuti",array("tipo"=>"articolo")); ?></span></h3>
                    <span>Articoli</span><img class="img-fluid float-right mr-3" src="../template/img/dash/icona_dash_Articoli.svg" alt="Articoli">
                </div>
                <div class="pt-0 px-3 pb-3">
                    <div class="btn-group d-flex" role="group">
                      <a class="btn btn-light w-100 aggiungi" href="../controller/controllerContenuti.php?operazione=creaArticolo">Nuovo</a>
                      <a class="btn btn-outline-light w-100 leggi-tutto" href="gestioneContenuti.php?tipo=articolo">Vedi tutti</a>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="col-sm-6 col-lg-3 mb-3 mb-lg-0">
            <div class="text-light item">
                <div class="p-3">
                    <h3 class="mb-1"><span class=""><?php echo $geecomDb->contaRigheTabella("geecB_contenuti",array("tipo"=>"pagina")); ?></span></h3>
                    <span>Pagine</span>
                    <img class="img-fluid float-right mr-3" src="../template/img/dash/icona_dash_Pagine.svg" alt="Articoli">
                </div>
                <div class="pt-0 px-3 pb-3">
                    <div class="btn-group d-flex" role="group">
                        <a class="btn btn-light w-100 aggiungi" href="creaContenuto.php?tipo=pagina">Nuova</a>
                        <a class="btn btn-outline-light w-100 leggi-tutto" href="gestioneContenuti.php?tipo=pagina">Vedi tutte</a>
                    </div>
                </div>
            </div>
        </div><!--/contatore-->

        <div class="col-sm-6 col-lg-3 mb-3 mb-lg-0">
            <div class="text-light item">
                <div class="p-3">
                  <h3 class="mb-1"><span class=""><?php echo $geecomDb->contaRigheTabella("geecB_contenuti",array("tipo"=>"galleria")); ?></span></h3>
                  <span>Gallerie</span><img class="img-fluid float-right mr-3" src="../template/img/dash/icona_dash_Gallerie.svg" alt="Risorse">
                </div>
                <div class="pt-0 px-3 pb-3">
                    <div class="btn-group d-flex" role="group">
                      <a class="btn btn-light w-100 aggiungi" href="creaContenuto.php?tipo=galleria">Nuova</a>
                      <a class="btn btn-outline-light w-100 leggi-tutto" href="gestioneContenuti.php?tipo=galleria">Vedi tutte</a>
                    </div>
                </div>
            </div>
        </div><!--/contatore-->

        <div class="col-sm-6 col-lg-3 mb-3 mb-lg-0">
            <div class="text-light item">
                <div class="p-3">
                    <h3 class="mb-1"><span class=""><?php echo $geecomDb->contaRigheTabella("geecB_risorse"); ?></span></h3>
                    <span>Risorse</span>
                    <img class="img-fluid float-right mr-3" src="../template/img/dash/icona_dash_Risorse.svg" alt="Pagine">
                </div>
                <div class="pt-0 px-3 pb-3">
                    <div class="btn-group d-flex" role="group">
                        <a class="btn btn-light w-100 aggiungi" href="../controller/controllerRisorse.php?operazione=creaFileScaricabile&id=0">Nuova</a>
                        <a class="btn btn-outline-light w-100 leggi-tutto" href="gestioneRisorse.php">Vedi tutte</a>
                    </div>
                </div>
            </div>
        </div><!--/contatore-->
    </div>